local editMods = Def.ActorFrame{
	LoadActor(THEME:GetPathB("_edit speedmod","shared"));
};

-- and now for the hard part.
local machineProfileDir = PROFILEMAN:GetProfileDir('ProfileSlot_Machine')
local speedModPath = machineProfileDir.."SpeedMods.txt"
local mods = ParseSpeedModFile(speedModPath)
mods = SpeedModSort(mods)

local function SpeedModItem(text,index)
	return Def.ActorFrame{
		Name="Item"..index;
		ListInputMessageCommand=function(self,p)
			local idx = p.Index
			local oldIdx = idx
			if p.Dir == "Up" then
				if idx - 1 < 1 then
					idx = #mods
				else
					idx = idx - 1
				end
				MESSAGEMAN:Broadcast("ListIndex",{New = idx, Old = oldIdx})
			elseif p.Dir == "Down" then
				if idx + 1 > #mods then
					idx = 1
				else
					idx = idx + 1
				end
				MESSAGEMAN:Broadcast("ListIndex",{New = idx, Old = oldIdx})
			end
			local t = self:GetChild("Text")
			if index == idx then
				t:playcommand("GainFocus")
			else
				t:playcommand("LoseFocus")
			end
		end;

		LoadFont("_francophilsans Bold 24px")..{
			Name="Text";
			Text=text;
			InitCommand=cmd(zoom,18/24;shadowlength,1);
			BeginCommand=function(self)
				-- todo: don't play GainFocus until List is active
				self:playcommand(index == 1 and "GainFocus" or "LoseFocus")
			end;
			GainFocusCommand=cmd(diffuse,color("1,1,1,1"));
			LoseFocusCommand=cmd(diffuse,color("0.625,0.625,0.625,1"));
		}
	}
end
local function _SpeedMods()
	local r = {}
	local count = 0
	for k,v in pairs(mods) do
		count = count + 1
		table.insert(r,SpeedModItem(v,count))
	end
	return r
end

local scroller = Def.ActorScroller{
	InitCommand=cmd(x,SCREEN_CENTER_X-240;CenterY);
	SecondsPerItem=0.2,
	NumItemsToDraw=32,
	TransformFunction = function( self, offset, itemIndex, numItems)
		self:y(20*(itemIndex-(numItems-1)/2))
	end;
	children=_SpeedMods(),
}

table.insert(editMods,scroller)

return editMods